<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title ?? 'Admin Panel') ?></title>
    
    <!-- Preconnect -->
    <link rel="preconnect" href="https://cdn.jsdelivr.net">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?= base_url('assets/css/admin.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/css/image-modal.css') ?>">
    
    <?= $this->renderSection('styles') ?>
</head>
<body style="background: linear-gradient(135deg, #87CEEB 0%, #4169E1 100%); min-height: 100vh; font-family: 'Inter', sans-serif; padding-top: 80px;">
    <!-- Loading Screen -->
    <div id="page-loader">
        <div class="loader-content">
            <div class="loader-spinner"></div>
            <div class="loader-text">
                <i class="bi bi-stars me-2"></i>Tunggu sebentar yahh..
            </div>
        </div>
    </div>
    
    <!-- Admin Navbar -->
    <?= $this->include('components/admin_navbar') ?>
    
    <!-- Main Content -->
    <main class="admin-main">
        <div class="container-fluid admin-container">
            <?= $this->renderSection('content') ?>
        </div>
    </main>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?= base_url('assets/js/admin.js') ?>"></script>
    
    <!-- Image Modal for Full View -->
    <div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(20px); border: 1px solid rgba(135, 206, 235, 0.3); border-radius: 16px;">
                <div class="modal-header" style="border-bottom: 1px solid rgba(135, 206, 235, 0.3);">
                    <h5 class="modal-title" style="color: #1E3A8A;" id="imageModalLabel">Lihat Gambar</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="filter: invert(1);"></button>
                </div>
                <div class="modal-body text-center p-0">
                    <img id="modalImage" src="" alt="" class="img-fluid w-100" style="max-height: 80vh; object-fit: contain; border-radius: 8px;">
                </div>
                <div class="modal-footer" style="border-top: 1px solid rgba(135, 206, 235, 0.3); justify-content: center;">
                    <button type="button" class="btn" style="background: linear-gradient(135deg, #87CEEB, #4169E1); color: white; border: none; border-radius: 25px;" onclick="downloadImage()">
                        <i class="bi bi-download me-1"></i>Download
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="background: rgba(135, 206, 235, 0.2); color: #1E3A8A; border: 1px solid rgba(135, 206, 235, 0.3); border-radius: 25px;">Tutup</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Video Modal for Full View -->
    <div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content" style="background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(20px); border: 1px solid rgba(135, 206, 235, 0.3); border-radius: 16px;">
                <div class="modal-header" style="border-bottom: 1px solid rgba(135, 206, 235, 0.3);">
                    <h5 class="modal-title" style="color: #1E3A8A;" id="videoModalLabel">Putar Video</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="filter: invert(1);"></button>
                </div>
                <div class="modal-body text-center p-0">
                    <video id="modalVideo" controls class="w-100" style="max-height: 80vh; border-radius: 8px;">
                        <source id="modalVideoSource" src="" type="video/mp4">
                        Browser Anda tidak mendukung video HTML5.
                    </video>
                </div>
                <div class="modal-footer" style="border-top: 1px solid rgba(135, 206, 235, 0.3); justify-content: center;">
                    <button type="button" class="btn" style="background: linear-gradient(135deg, #87CEEB, #4169E1); color: white; border: none; border-radius: 25px;" onclick="downloadVideo()">
                        <i class="bi bi-download me-1"></i>Download
                    </button>
                    <button type="button" class="btn" style="background: linear-gradient(135deg, #FFB6C1, #FF69B4); color: white; border: none; border-radius: 25px;" onclick="toggleFullscreen()">
                        <i class="bi bi-fullscreen me-1"></i>Fullscreen
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="background: rgba(135, 206, 235, 0.2); color: #1E3A8A; border: 1px solid rgba(135, 206, 235, 0.3); border-radius: 25px;">Tutup</button>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Image Modal Functions
        function showImageModal(imageUrl, altText) {
            const modal = new bootstrap.Modal(document.getElementById('imageModal'));
            const modalImage = document.getElementById('modalImage');
            const modalTitle = document.getElementById('imageModalLabel');
            
            modalImage.src = imageUrl;
            modalImage.alt = altText || 'Gambar';
            modalTitle.textContent = altText || 'Lihat Gambar';
            
            modal.show();
        }
        
        function downloadImage() {
            const modalImage = document.getElementById('modalImage');
            const link = document.createElement('a');
            link.href = modalImage.src;
            link.download = modalImage.alt || 'image';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }

        // Video Modal Functions
        function showVideoModal(videoUrl, title) {
            const modal = new bootstrap.Modal(document.getElementById('videoModal'));
            const modalVideo = document.getElementById('modalVideo');
            const modalVideoSource = document.getElementById('modalVideoSource');
            const modalTitle = document.getElementById('videoModalLabel');
            
            // Stop any currently playing video
            modalVideo.pause();
            modalVideo.currentTime = 0;
            
            // Set new video source
            modalVideoSource.src = videoUrl;
            modalVideo.load(); // Reload video with new source
            modalTitle.textContent = title || 'Putar Video';
            
            modal.show();
            
            // Auto play when modal is shown
            setTimeout(() => {
                modalVideo.play().catch(e => {
                    console.log('Auto-play prevented by browser:', e);
                });
            }, 500);
        }
        
        function downloadVideo() {
            const modalVideoSource = document.getElementById('modalVideoSource');
            const link = document.createElement('a');
            link.href = modalVideoSource.src;
            link.download = 'video';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
        
        function toggleFullscreen() {
            const modalVideo = document.getElementById('modalVideo');
            
            if (modalVideo.requestFullscreen) {
                modalVideo.requestFullscreen();
            } else if (modalVideo.webkitRequestFullscreen) {
                modalVideo.webkitRequestFullscreen();
            } else if (modalVideo.msRequestFullscreen) {
                modalVideo.msRequestFullscreen();
            }
        }

        // Pause video when modal is closed
        document.getElementById('videoModal').addEventListener('hidden.bs.modal', function () {
            const modalVideo = document.getElementById('modalVideo');
            modalVideo.pause();
            modalVideo.currentTime = 0;
        });
        
        // Add click handlers to all images with image-clickable class
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.image-clickable').forEach(img => {
                img.style.cursor = 'pointer';
                img.addEventListener('click', function() {
                    const fullImageUrl = this.dataset.fullImage || this.src;
                    const altText = this.alt || 'Gambar';
                    showImageModal(fullImageUrl, altText);
                });
            });
            
            // 💙 Admin Navbar - Static (No Scroll Animation)
            // Navbar stays white/static - no scroll changes needed
        });
    </script>
    
    <?= $this->renderSection('scripts') ?>
</body>
</html>

